/*
 * Decompiled with CFR 0.152.
 */
package ee.mare.indrek.sablecc.gen4sablecc;

import ee.mare.indrek.sablecc.xss.XSS2XSLReader;
import java.io.File;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class Main {
    private static void usage() {
        System.err.println("Usage: sableccgen (target|xsl:path.xsl|xss:path.xss) infile.xml [options ..]");
        System.err.println("    [-p key=value]           give parameters to generator");
        System.err.println("    [-o output-file]         where to write direct output");
        System.err.println("    [-d destionation-path]   same as -p dest_dir=path");
        System.err.println("    [-b]                     generate buildsystem, same as -p build_system=1");
        System.err.println("Targets and their options:");
        System.err.println("  java");
        System.err.println("    -d destionation-path     where to place output files");
        System.err.println("    -b                       generate ant based build system");
        System.err.println("    -p src=suffix            use suffix where to place the source files (.)");
        System.err.println("  csharp");
        System.err.println("    -d destionation-path     path where to place output files");
        System.err.println("    -b                       generate make based build system");
        System.err.println("  cxx");
        System.err.println("    -d destionation-path     path where to place output files");
        System.err.println("    -b                       generate automake based build system");
        System.err.println("  dotgraph");
        System.err.println("    -o output-file");
        System.exit(1);
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length < 3) {
            Main.usage();
        }
        if (!(new File(argv[0] + "/" + argv[1] + "/main.xsl").exists() || new File(argv[0] + "/" + argv[1] + "/main.xss").exists() || argv[1].startsWith("xsl:") || argv[1].startsWith("xss:"))) {
            Main.usage();
        }
        TransformerFactory fact = TransformerFactory.newInstance();
        Transformer transformer = argv[1].startsWith("xsl:") ? fact.newTransformer(new StreamSource(argv[1].substring("xsl:".length()))) : (argv[1].startsWith("xss:") ? fact.newTransformer(new StreamSource(new XSS2XSLReader(argv[1].substring("xss:".length())))) : (new File(argv[0] + "/" + argv[1] + "/main.xss").exists() ? fact.newTransformer(new StreamSource(new XSS2XSLReader(argv[0] + "/" + argv[1] + "/main.xss"))) : fact.newTransformer(new StreamSource(argv[0] + "/" + argv[1] + "/main.xsl"))));
        String xml = argv[2];
        String output = null;
        for (int i = 3; i < argv.length; ++i) {
            if (argv[i].equals("-d")) {
                if (++i >= argv.length) {
                    Main.usage();
                }
                transformer.setParameter("dest_dir", new File(argv[i]).getAbsolutePath());
                continue;
            }
            if (argv[i].equals("-o")) {
                if (++i >= argv.length) {
                    Main.usage();
                }
                output = new File(argv[i]).getAbsolutePath();
                continue;
            }
            if (argv[i].equals("-p")) {
                String param;
                int s;
                if (++i >= argv.length) {
                    Main.usage();
                }
                if ((s = (param = argv[i]).indexOf(61)) == -1) {
                    transformer.setParameter(param, "1");
                    continue;
                }
                transformer.setParameter(param.substring(0, s), param.substring(s + 1));
                continue;
            }
            if (argv[i].equals("-b")) {
                transformer.setParameter("build_system", "1");
                continue;
            }
            Main.usage();
        }
        if (output == null) {
            StringWriter sw = new StringWriter();
            transformer.transform(new StreamSource(xml), new StreamResult(sw));
            String str = sw.toString();
            if (!str.trim().equals("")) {
                System.out.print(str);
            }
        } else {
            transformer.transform(new StreamSource(xml), new StreamResult(output));
        }
    }
}

