/*
 * Decompiled with CFR 0.152.
 */
package ee.mare.indrek.sablecc.xss;

import ee.mare.indrek.sablecc.xss.XSS2XSLChecker;
import ee.mare.indrek.sablecc.xss.XSSReader;
import ee.mare.indrek.sablecc.xss.analysis.DepthFirstAdapter;
import ee.mare.indrek.sablecc.xss.lexer.Lexer;
import ee.mare.indrek.sablecc.xss.lexer.LexerException;
import ee.mare.indrek.sablecc.xss.node.AArg;
import ee.mare.indrek.sablecc.xss.node.ACallStatement;
import ee.mare.indrek.sablecc.xss.node.AChooseStatement;
import ee.mare.indrek.sablecc.xss.node.AChooseWhen;
import ee.mare.indrek.sablecc.xss.node.ADataStatement;
import ee.mare.indrek.sablecc.xss.node.AEcmascriptStatement;
import ee.mare.indrek.sablecc.xss.node.AForeachStatement;
import ee.mare.indrek.sablecc.xss.node.AIattribExpr;
import ee.mare.indrek.sablecc.xss.node.AIfStatement;
import ee.mare.indrek.sablecc.xss.node.AIncludeStatement;
import ee.mare.indrek.sablecc.xss.node.AIvarExpr;
import ee.mare.indrek.sablecc.xss.node.AIxpathExpr;
import ee.mare.indrek.sablecc.xss.node.ALiteralExpr;
import ee.mare.indrek.sablecc.xss.node.AOarg;
import ee.mare.indrek.sablecc.xss.node.AOutputStatement;
import ee.mare.indrek.sablecc.xss.node.AParamStatement;
import ee.mare.indrek.sablecc.xss.node.APrintStatement;
import ee.mare.indrek.sablecc.xss.node.AReverseForeachStatement;
import ee.mare.indrek.sablecc.xss.node.AScript;
import ee.mare.indrek.sablecc.xss.node.ASetStatement;
import ee.mare.indrek.sablecc.xss.node.ATemplateStatement;
import ee.mare.indrek.sablecc.xss.node.AXpathExpr;
import ee.mare.indrek.sablecc.xss.node.Node;
import ee.mare.indrek.sablecc.xss.node.PStatement;
import ee.mare.indrek.sablecc.xss.node.Start;
import ee.mare.indrek.sablecc.xss.parser.Parser;
import ee.mare.indrek.sablecc.xss.parser.ParserException;
import java.io.File;
import java.io.FileReader;
import java.io.PushbackReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class XSS2XSLTransformer
extends DepthFirstAdapter {
    final String path;
    final StringBuffer out;
    final StringBuffer root;
    private Map node2str = new HashMap();

    private void setNode(Node n, String str) {
        this.node2str.put(n, str);
    }

    private String getNode(Node n) {
        return (String)this.node2str.get(n);
    }

    XSS2XSLTransformer(String path, StringBuffer root) {
        this.path = path;
        this.out = new StringBuffer();
        this.root = root;
    }

    public void outADataStatement(ADataStatement node) {
        this.setNode(node, "<xsl:text>" + XSS2XSLTransformer.data(node.getData().getText()) + "</xsl:text>\n");
    }

    public void outAForeachStatement(AForeachStatement node) {
        StringBuffer buf = new StringBuffer();
        buf.append("<xsl:for-each select=\"" + XSS2XSLTransformer.xpath(node.getXpath().getText()) + "\">");
        if (node.getVar() != null) {
            buf.append("<xsl:variable name=\"" + node.getVar().getText() + "\" select=\".\"/>");
        }
        Iterator it = node.getStatement().iterator();
        while (it.hasNext()) {
            buf.append(this.getNode((PStatement)it.next()));
        }
        buf.append("</xsl:for-each>\n");
        this.setNode(node, buf.toString());
    }

    public void outAReverseForeachStatement(AReverseForeachStatement node) {
        StringBuffer buf = new StringBuffer();
        buf.append("<xsl:for-each select=\"" + XSS2XSLTransformer.xpath(node.getXpath().getText()) + "\">");
        buf.append("<xsl:sort select=\"position()\" data-type=\"number\" order=\"descending\"/>");
        if (node.getVar() != null) {
            buf.append("<xsl:variable name=\"" + node.getVar().getText() + "\" select=\".\"/>");
        }
        Iterator it = node.getStatement().iterator();
        while (it.hasNext()) {
            buf.append(this.getNode((PStatement)it.next()));
        }
        buf.append("</xsl:for-each>\n");
        this.setNode(node, buf.toString());
    }

    public void outAIfStatement(AIfStatement node) {
        StringBuffer buf = new StringBuffer();
        buf.append("<xsl:choose>");
        buf.append("<xsl:when test=\"" + this.getNode(node.getTest()) + "\">");
        Iterator it = node.getStatement().iterator();
        while (it.hasNext()) {
            buf.append(this.getNode((PStatement)it.next()));
        }
        buf.append("</xsl:when>");
        buf.append("<xsl:otherwise>");
        it = node.getElse().iterator();
        while (it.hasNext()) {
            buf.append(this.getNode((PStatement)it.next()));
        }
        buf.append("</xsl:otherwise>");
        buf.append("</xsl:choose>\n");
        this.setNode(node, buf.toString());
    }

    public void outAChooseStatement(AChooseStatement node) {
        StringBuffer buf = new StringBuffer();
        buf.append("<xsl:choose>");
        Iterator it = node.getChooseWhen().iterator();
        while (it.hasNext()) {
            AChooseWhen w = (AChooseWhen)it.next();
            buf.append("<xsl:when test=\"" + this.getNode(w.getTest()) + "\">");
            Iterator jt = w.getStatement().iterator();
            while (jt.hasNext()) {
                buf.append(this.getNode((PStatement)jt.next()));
            }
            buf.append("</xsl:when>");
        }
        buf.append("<xsl:otherwise>");
        it = node.getOtherwise().iterator();
        while (it.hasNext()) {
            buf.append(this.getNode((PStatement)it.next()));
        }
        buf.append("</xsl:otherwise>");
        buf.append("</xsl:choose>\n");
        this.setNode(node, buf.toString());
    }

    public void outAEcmascriptStatement(AEcmascriptStatement node) {
        this.root.append("<xalan:component prefix=\"sablecc\">");
        this.root.append("<xalan:script lang=\"javascript\">");
        this.root.append(XSS2XSLTransformer.data(node.getScript().getText()));
        this.root.append("</xalan:script>");
        this.root.append("</xalan:component>\n");
        this.setNode(node, "");
    }

    public void outASetStatement(ASetStatement node) {
        StringBuffer buf = new StringBuffer();
        Iterator it = node.getArgs().iterator();
        while (it.hasNext()) {
            AArg arg = (AArg)it.next();
            buf.append("<xsl:variable name=\"" + arg.getVar().getText() + "\" select=\"" + this.getNode(arg.getExpr()) + "\"/>\n");
        }
        this.setNode(node, buf.toString());
    }

    public void outAParamStatement(AParamStatement node) {
        Iterator it = node.getArgs().iterator();
        while (it.hasNext()) {
            this.root.append(this.getNode((AOarg)it.next()));
        }
        this.setNode(node, "");
    }

    public void outAOutputStatement(AOutputStatement node) {
        StringBuffer buf = new StringBuffer();
        buf.append("<redirect:write select=\"" + this.getNode(node.getExpr()) + "\" mkdirs=\"true\">");
        Iterator it = node.getStatement().iterator();
        while (it.hasNext()) {
            buf.append(this.getNode((PStatement)it.next()));
        }
        buf.append("</redirect:write>\n");
        this.setNode(node, buf.toString());
    }

    public void outAIncludeStatement(AIncludeStatement node) {
        String include = new File(new File(this.path).getParent(), XSS2XSLTransformer.literal(node.getPath().getText())).getAbsolutePath();
        try {
            Lexer lexer = new Lexer(new PushbackReader(new FileReader(include), 65535));
            Parser parser = new Parser(lexer);
            Start start = parser.parse();
            start.apply(new XSS2XSLChecker(include));
            lexer = new Lexer(new PushbackReader(new XSSReader(new FileReader(include)), 65535));
            parser = new Parser(lexer);
            start = parser.parse();
            XSS2XSLTransformer tr = new XSS2XSLTransformer(new File(include).getAbsolutePath(), this.root);
            start.apply(tr);
            this.setNode(node, tr.out.toString());
        }
        catch (LexerException le) {
            System.err.println(this.path + ":" + node.getPath().getLine() + ":error: at include '" + include + "':");
            System.err.println(include + ":" + le.getMessage());
            this.setNode(node, "");
        }
        catch (ParserException pe) {
            System.err.println(this.path + ":" + node.getPath().getLine() + ":error: at include '" + include + "':");
            System.err.println(include + ":" + pe.getMessage());
            this.setNode(node, "");
        }
        catch (Exception e) {
            System.err.println(this.path + ":" + node.getPath().getLine() + ":error: at include '" + include + "':");
            e.printStackTrace();
            this.setNode(node, "");
        }
    }

    public void outATemplateStatement(ATemplateStatement node) {
        this.root.append("<xsl:template name=\"" + node.getName().getText() + "\">");
        Iterator it = node.getArgs().iterator();
        while (it.hasNext()) {
            this.root.append(this.getNode((AOarg)it.next()));
        }
        it = node.getStatement().iterator();
        while (it.hasNext()) {
            this.root.append(this.getNode((PStatement)it.next()));
        }
        this.root.append("</xsl:template>\n");
        this.setNode(node, "");
    }

    public void outACallStatement(ACallStatement node) {
        StringBuffer buf = new StringBuffer();
        buf.append("<xsl:call-template name=\"" + node.getName().getText() + "\">");
        Iterator it = node.getArgs().iterator();
        while (it.hasNext()) {
            AArg arg = (AArg)it.next();
            buf.append("<xsl:with-param name=\"" + arg.getVar().getText() + "\" select=\"" + this.getNode(arg.getExpr()) + "\"/>\n");
        }
        buf.append("</xsl:call-template>\n");
        this.setNode(node, buf.toString());
    }

    public void outAOarg(AOarg node) {
        if (node.getExpr() != null) {
            this.setNode(node, "<xsl:param name=\"" + node.getVar().getText() + "\" select=\"" + this.getNode(node.getExpr()) + "\"/>\n");
        } else {
            this.setNode(node, "<xsl:param name=\"" + node.getVar().getText() + "\"/>\n");
        }
    }

    public void outALiteralExpr(ALiteralExpr node) {
        String str = XSS2XSLTransformer.literal(node.getLiteral().getText());
        StringBuffer buf = new StringBuffer();
        block3: for (int i = 0; i < str.length(); ++i) {
            char n = str.charAt(i);
            switch (n) {
                case '\'': {
                    buf.append("&#39;");
                    continue block3;
                }
                default: {
                    buf.append(n);
                }
            }
        }
        this.setNode(node, "'" + buf.toString() + "'");
    }

    public void outAPrintStatement(APrintStatement node) {
        this.setNode(node, "<xsl:value-of select=\"" + this.getNode(node.getExpr()) + "\"/>\n");
    }

    public void outAXpathExpr(AXpathExpr node) {
        String xp = XSS2XSLTransformer.xpath(node.getXpath().getText());
        this.setNode(node, xp);
    }

    public void outAIxpathExpr(AIxpathExpr node) {
        String xp = XSS2XSLTransformer.xpath(node.getIxpath().getText().substring(1));
        this.setNode(node, xp);
    }

    public void outAIattribExpr(AIattribExpr node) {
        this.setNode(node, XSS2XSLTransformer.attrib(node.getIattrib().getText()));
    }

    public void outAIvarExpr(AIvarExpr node) {
        this.setNode(node, node.getIvar().getText());
    }

    public void outAScript(AScript node) {
        Iterator it = node.getStatement().iterator();
        while (it.hasNext()) {
            this.out.append(this.getNode((PStatement)it.next()));
        }
    }

    static String literal(String str) {
        StringBuffer buf = new StringBuffer();
        for (int i = 1; i < str.length() - 1; ++i) {
            char n = str.charAt(i);
            if (n == str.charAt(0)) {
                buf.append(n);
                ++i;
                continue;
            }
            buf.append(n);
        }
        return buf.toString();
    }

    static String xpath(String xpath) {
        xpath = xpath.substring(1, xpath.length() - 1);
        StringBuffer buf = new StringBuffer();
        block3: for (int i = 0; i < xpath.length(); ++i) {
            char n = xpath.charAt(i);
            switch (n) {
                case '{': 
                case '}': {
                    buf.append(n);
                    ++i;
                    continue block3;
                }
                default: {
                    buf.append(n);
                }
            }
        }
        return buf.toString();
    }

    static String data(String str) {
        StringBuffer buf = new StringBuffer();
        block5: for (int i = 0; i < str.length(); ++i) {
            char n = str.charAt(i);
            if (n >= 'a' && n <= 'z' || n >= 'A' && n <= 'Z' || n >= '0' && n <= '9') {
                buf.append(n);
                continue;
            }
            switch (n) {
                case '$': 
                case '@': {
                    buf.append(n);
                    ++i;
                    continue block5;
                }
                case '[': {
                    buf.append(n);
                    if (i + 2 >= str.length() || str.charAt(i + 1) != '-' || str.charAt(i + 2) != '-') continue block5;
                    ++i;
                    continue block5;
                }
                case ' ': 
                case '!': 
                case '#': 
                case '%': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '?': 
                case '\\': 
                case ']': 
                case '^': 
                case '_': 
                case '`': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    buf.append(n);
                    continue block5;
                }
                default: {
                    buf.append("&#" + n + ";");
                }
            }
        }
        return buf.toString();
    }

    static String attrib(String str) {
        if (str.charAt(1) == '{') {
            str = "@" + str.substring(2, str.length() - 1);
        }
        return str;
    }
}

