/*
 * Decompiled with CFR 0.152.
 */
package ee.mare.indrek.sablecc.xml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.sablecc.sablecc.ParserData;
import org.sablecc.sablecc.ParserGenerator;

public class XMLGenerator
implements ParserGenerator {
    public void init(String arguments) throws Exception {
    }

    public String getName() {
        return "XML generator for SableCC";
    }

    public String getInfo() {
        return "XML for SableCC parser generator\nCopyright (C) 2003 Indrek Mandre <indrek@mare.ee>";
    }

    public String getHelp() {
        return "";
    }

    public void generate(ParserData data, String path) throws Exception {
        Vector row;
        Object action;
        Enumeration jt;
        Object elem;
        Object kt;
        Object state;
        Object jt2;
        BufferedWriter out = new BufferedWriter(new FileWriter(new File(path, "parser.xml")));
        out.write("<?xml version=\"1.0\"?>\n");
        out.write("<parser package=\"" + this.escape(data.package_name) + "\" generator=\"SableCC3\" date=\"" + new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S zzz").format(new Date()) + "\">\n");
        out.write("  <tokens>\n");
        Object it = data.token_list.iterator();
        while (it.hasNext()) {
            ParserData.Token token = (ParserData.Token)it.next();
            out.write("    <token name=\"" + this.escape(token.name) + "\" ename=\"" + this.escape(token.ename) + "\"");
            if (token.value != null) {
                out.write(" value=\"" + this.escape(token.value) + "\"");
            }
            if (token.index != -1) {
                out.write(" parser_index=\"" + token.index + "\"");
            }
            if (token.transitions.size() == 0) {
                out.write("/>\n");
                continue;
            }
            out.write(">\n");
            jt2 = token.transitions.entrySet().iterator();
            while (jt2.hasNext()) {
                Map.Entry entry = jt2.next();
                out.write("      <transition from=\"" + (String)entry.getKey() + "\" to=\"" + (String)entry.getValue() + "\"/>\n");
            }
            out.write("    </token>\n");
        }
        out.write("    <eof parser_index=\"" + data.eof_index + "\"/>\n");
        out.write("  </tokens>\n");
        out.write("  <lexer_data>\n");
        it = data.state_list.iterator();
        while (it.hasNext()) {
            state = (ParserData.LexerState)it.next();
            out.write("    <state name=\"" + this.escape(((ParserData.LexerState)state).name) + "\" id=\"" + ((ParserData.LexerState)state).id + "\"/>\n");
        }
        out.write("    <accept_table>\n");
        it = data.lexer_accept.elements();
        while (it.hasMoreElements()) {
            Vector row2 = (Vector)it.nextElement();
            out.write("      <state>\n");
            out.write("        ");
            jt2 = row2.elements();
            while (jt2.hasMoreElements()) {
                out.write("<i>" + ((Number)jt2.nextElement()).intValue() + "</i>");
            }
            out.write("\n");
            out.write("      </state>\n");
        }
        out.write("    </accept_table>\n");
        out.write("    <goto_table>\n");
        it = data.lexer_goto_table.elements();
        while (it.hasMoreElements()) {
            state = (Vector)it.nextElement();
            out.write("      <state>\n");
            jt2 = ((Vector)state).elements();
            while (jt2.hasMoreElements()) {
                Vector row3 = (Vector)jt2.nextElement();
                out.write("        <row>\n");
                kt = row3.elements();
                while (kt.hasMoreElements()) {
                    elem = (int[])kt.nextElement();
                    out.write("          <goto low=\"" + elem[0] + "\" high=\"" + elem[1] + "\" state=\"" + elem[2] + "\"/>\n");
                }
                out.write("        </row>\n");
            }
            out.write("      </state>\n");
        }
        out.write("    </goto_table>\n");
        out.write("  </lexer_data>\n");
        out.write("  <productions>\n");
        it = data.production_list.iterator();
        while (it.hasNext()) {
            ParserData.Production prod = (ParserData.Production)it.next();
            out.write("    <production name=\"" + this.escape(prod.name) + "\" ename=\"" + this.escape(prod.ename) + "\">\n");
            jt2 = prod.alts.iterator();
            while (jt2.hasNext()) {
                ParserData.Alt alt = (ParserData.Alt)jt2.next();
                out.write("      <alt name=\"" + this.escape(alt.name) + "\" ename=\"" + this.escape(alt.ename) + "\">\n");
                kt = alt.elems.iterator();
                while (kt.hasNext()) {
                    elem = (ParserData.Elem)kt.next();
                    out.write("        <elem name=\"" + this.escape(elem.name) + "\" ename=\"" + this.escape(elem.ename) + "\" type=\"" + this.escape(elem.type) + "\" etype=\"" + elem.etype + "\"");
                    if (elem.modifier != null) {
                        out.write(" modifier=\"" + this.escape(elem.modifier) + "\"");
                    }
                    if (elem.is_token) {
                        out.write(" is_token=\"true\"");
                    }
                    if (elem.is_list) {
                        out.write(" is_list=\"true\"");
                    }
                    out.write("/>\n");
                }
                out.write("      </alt>\n");
            }
            out.write("    </production>\n");
        }
        out.write("  </productions>\n");
        String[] cmd2str = new String[]{"POP", "FETCHNODE", "FETCHLIST", "ADDNODE", "ADDLIST", "MAKELIST", "MAKENODE", "RETURNNODE", "RETURNLIST"};
        out.write("  <rules>\n");
        Enumeration it2 = data.rules_list.iterator();
        while (it2.hasNext()) {
            ParserData.Rule rule = (ParserData.Rule)it2.next();
            out.write("    <rule ename=\"" + this.escape(rule.ename) + "\" index=\"" + rule.index + "\" leftside=\"" + rule.leftside + "\">\n");
            jt = rule.actions.iterator();
            block19: while (jt.hasNext()) {
                action = (ParserData.Action)jt.next();
                out.write("      <action cmd=\"" + cmd2str[action.cmd] + "\"");
                if (action.result != null) {
                    out.write(" result=\"" + this.escape(action.result) + "\"");
                }
                if (action.index != -1) {
                    out.write(" index=\"" + action.index + "\"");
                }
                if (action.etype != null) {
                    out.write(" etype=\"" + this.escape(action.etype) + "\"");
                }
                switch (action.cmd) {
                    case 1: 
                    case 2: {
                        out.write(" from=\"" + this.escape(action.arg[0]) + "\"/>\n");
                        continue block19;
                    }
                    case 7: {
                        if (action.arg[0] == null) {
                            out.write(" null=\"true\"/>\n");
                            continue block19;
                        }
                        out.write(" node=\"" + this.escape(action.arg[0]) + "\"/>\n");
                        continue block19;
                    }
                    case 8: {
                        out.write(" list=\"" + this.escape(action.arg[0]) + "\"/>\n");
                        continue block19;
                    }
                    case 3: {
                        out.write(" tolist=\"" + this.escape(action.arg[0]) + "\" node=\"" + this.escape(action.arg[1]) + "\"/>\n");
                        continue block19;
                    }
                    case 4: {
                        out.write(" tolist=\"" + this.escape(action.arg[0]) + "\" fromlist=\"" + this.escape(action.arg[1]) + "\"/>\n");
                        continue block19;
                    }
                }
                if (action.arg.length == 0) {
                    out.write("/>\n");
                    continue;
                }
                out.write(">\n");
                for (int i = 0; i < action.arg.length; ++i) {
                    if (action.arg[i] == null) {
                        out.write("        <arg null=\"true\"/>\n");
                        continue;
                    }
                    out.write("        <arg>" + this.escape(action.arg[i]) + "</arg>\n");
                }
                out.write("      </action>\n");
            }
            out.write("    </rule>\n");
        }
        out.write("  </rules>\n");
        out.write("  <parser_data>\n");
        out.write("    <action_table>\n");
        it2 = data.parser_action_table.elements();
        while (it2.hasMoreElements()) {
            row = (Vector)it2.nextElement();
            out.write("      <row>\n");
            jt = row.elements();
            while (jt.hasMoreElements()) {
                action = (int[])jt.nextElement();
                out.write("        <action from=\"" + action[0] + "\" action=\"" + action[1] + "\" to=\"" + action[2] + "\"/>\n");
            }
            out.write("      </row>\n");
        }
        out.write("    </action_table>\n");
        out.write("    <goto_table>\n");
        it2 = data.parser_goto_table.elements();
        while (it2.hasMoreElements()) {
            row = (Vector)it2.nextElement();
            out.write("      <row>\n");
            jt = row.elements();
            while (jt.hasMoreElements()) {
                action = (int[])jt.nextElement();
                out.write("        <goto from=\"" + action[0] + "\" to=\"" + action[1] + "\"/>\n");
            }
            out.write("      </row>\n");
        }
        out.write("    </goto_table>\n");
        out.write("    <errors>\n");
        out.write("      ");
        it2 = data.parser_errors.elements();
        while (it2.hasMoreElements()) {
            out.write("<i>" + (Integer)it2.nextElement() + "</i>");
        }
        out.write("\n");
        out.write("    </errors>\n");
        out.write("    <error_messages>\n");
        it2 = data.parser_error_messages.elements();
        while (it2.hasMoreElements()) {
            out.write("      <msg>" + this.escape((String)it2.nextElement()) + "</msg>\n");
        }
        out.write("    </error_messages>\n");
        out.write("  </parser_data>\n");
        out.write("</parser>\n");
        out.close();
    }

    public String escape(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        block3: for (int i = 0; i < str.length(); ++i) {
            char n = str.charAt(i);
            if (n >= 'a' && n <= 'z' || n >= 'A' && n <= 'Z' || n >= '0' && n <= '9') {
                out.append(n);
                continue;
            }
            switch (n) {
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '?': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '_': 
                case '`': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    out.append(n);
                    continue block3;
                }
                default: {
                    out.append("&#" + n + ";");
                }
            }
        }
        return out.toString();
    }
}

