<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>

<xsl:template match="parser">
package <xsl:value-of select="@package"/>.analysis;

import java.util.*;
import <xsl:value-of select="@package"/>.node.*;

public class MyDepthFirstAdapter extends AnalysisAdapter
{
    public void inStart(Start node)
    {
        defaultIn(node);
    }

    public void outStart(Start node)
    {
        defaultOut(node);
    }

    public void defaultIn(Node node)
    {
    }

    public void defaultOut(Node node)
    {
    }

    public void caseStart(Start node)
    {
        inStart(node);
        node.get<xsl:value-of select="production/@ename"/>().apply(this);
        node.getEOF().apply(this);
        outStart(node);
    }

<xsl:apply-templates select="//alt"/>
};
</xsl:template>

<xsl:template match="alt">
    void case<xsl:value-of select="@ename"/> (<xsl:value-of select="@ename"/> node)
    {
      in<xsl:value-of select="@ename"/> (node);<xsl:apply-templates select="elem"/>
      out<xsl:value-of select="@ename"/> (node);
    }

    void in<xsl:value-of select="@ename"/> (<xsl:value-of select="@ename"/> node)
    {
      defaultIn(node);
    }

    void out<xsl:value-of select="@ename"/> (<xsl:value-of select="@ename"/> node)
    {
      defaultOut(node);
    }
</xsl:template>

<xsl:template match="elem[@is_list='false']">
      if ( node.get<xsl:value-of select="@ename"/>() != null )
      {
          node.get<xsl:value-of select="@ename"/>().apply(this);
      }
</xsl:template>

<xsl:template match="elem[@is_list='true']">
      {
          Object temp[] = node.get<xsl:value-of select="@ename"/>().toArray();
          for(int i = 0; i &lt; temp.length; i++)
          {
              ((<xsl:value-of select="@etype"/>) temp[i]).apply(this);
          }
      }
</xsl:template>

</xsl:stylesheet>

